// This is the oracle. It compute f(S), i.e. the number of edges between S and V/S.
// This code calculate the number of calls to f and also average of output after each update.
#include<bits/stdc++.h>
#include "oracle.h"
using namespace std;

const int maxn = 1e6;
int M, Q, K;
long long query_count, max_cut_sum;
bool mark[maxn], available[maxn];
vector<int> neigh[maxn];
set<int> s_neigh[maxn];

// Calculate f(S U {new_element}) by knowing that f(S) = old_value and increase query_count by 1
// We implement this function to calculate f(S U {new_element}) faster
int f_additive(vector<int> S, int new_element, int old_value)
{
  query_count += 1;
  int cut = old_value + neigh[new_element].size();
  for(int i = 0; i < S.size(); i ++)
    { if(!available[S[i]])
	return -1;
      if(S[i] == new_element)
	return old_value;
      if(s_neigh[S[i]].find(new_element) != s_neigh[S[i]].end())
	cut -= 2;
    }
  return cut;
}

// Calculate f(S) and increase query_count by 1
int f(vector<int> S)
{
  query_count += 1;
  int cut = 0;
  memset(mark, false, sizeof mark);
  for(int i = 0; i < S.size(); i ++)
    {
      mark[S[i]] = true;
      if(!available[S[i]])
	return -1;
    }
  for(int i = 0; i < S.size(); i ++)
    {
      int v = S[i];
      for(int j = 0; j < neigh[v].size(); j ++)
	cut += !mark[neigh[v][j]];
    }
  return cut;
}

int main()
{
  cin >> M >> Q >> K;
  // Read graph
  for(int i = 0; i < M; i ++)
    {
      int v, u;
      cin >> v >> u;
      neigh[v].push_back(u);
      neigh[u].push_back(v);
      s_neigh[v].insert(u);
      s_neigh[u].insert(v);
    }
  // Call init(k) to initialize algorithms  
  init(K);
  // Add or remove elements
  for(int i = 0; i < Q; i ++)
    {
      int v;
      cin >> v;
      if(v > 0) {
	available[v] = true;
	max_cut_sum += add_element(v);
      }
      else {
	available[v] = false;
	max_cut_sum += remove_element(-v);
      }
    }
  // Print average founded cut and total number of query call
  cout<< (long double) max_cut_sum / Q << " " << query_count << endl; 
}
